/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWTableDefinition;
import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWParticipant;
import filenet.vw.base.VWString;
import filenet.vw.server.IPECommands;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class VWTableDefinition
extends VWMLABase
implements IVWTableDefinition,
Serializable,
Cloneable {
    private static final long serialVersionUID = 7570L;
    protected String name = null;
    protected int serverId = -1;
    protected boolean bHasChanged = false;
    protected VWExposedFieldDefinition[] theFieldDefs = null;
    protected VWArrayHandler theFieldsHandler = new VWArrayHandler();
    protected VWIndexDefinition[] theIndexDefs = null;
    protected VWArrayHandler theIndexHandler = new VWArrayHandler();
    private String[] readSecurity = null;
    private String[] writeSecurity = null;
    private VWParticipant[] readSecurityPx = null;
    private VWParticipant[] writeSecurityPx = null;
    protected String description = null;
    protected Hashtable attributes = null;
    public static final int LVALUE = 0;
    public static final int RVALUE = 1;
    protected int configType = 0;
    protected static final String MSFBindPending = "F_BindPending";
    protected static final String MSFBoundMachine = "F_BoundMachine";
    protected static final String MSFBoundUser = "F_BoundUser";
    protected static final String MSFBoundUserId = "F_BoundUserId";
    protected static final String MSFCreateTime = "F_CreateTime";
    protected static final String MSFDuration = "F_Duration";
    protected static final String MSFEnqueueTime = "F_EnqueueTime";
    protected static final String MSFEventType = "F_EventType";
    protected static final String MSFInstrSheetId = "F_InstrSheetId";
    protected static final String MSFLocked = "F_Locked";
    protected static final String MSFLockMachine = "F_LockMachine";
    protected static final String MSFLockTime = "F_LockTime";
    protected static final String MSFLockUser = "F_LockUser";
    protected static final String MSFMachineId = "F_MachineId";
    protected static final String MSFOccurrenceId = "F_OccurrenceId";
    protected static final String MSFOperationId = "F_OperationId";
    protected static final String MSFParentWobNum = "F_ParentWobNum";
    protected static final String MSFQueueWPClassId = "F_QueueWPClassId";
    protected static final String MSFSeqNumber = "F_SeqNumber";
    protected static final String MSFServerId = "F_ServerId";
    protected static final String MSFServerSeqNum = "F_ServerSeqNum";
    protected static final String MSFSortOrder = "F_SortOrder";
    protected static final String MSFTag = "F_Tag";
    protected static final String MSFText = "F_Text";
    protected static final String MSFTimeStamp = "F_TimeStamp";
    protected static final String MSFUserId = "F_UserId";
    protected static final String MSFWCRevision = "F_WCRevision";
    protected static final String MSFWobNum = "F_WobNum";
    protected static final String MSFWorkClassId = "F_WorkClassId";
    protected static final String MSFWorkOrderId = "F_WorkOrderId";
    protected static final String MSFWorkSpaceId = "F_WorkSpaceId";
    protected static final String MSFWPClassId = "F_WPClassId";
    public static final String IWFCaseFolder = "F_CaseFolder";
    public static final String IWFCaseTask = "F_CaseTask";
    protected static final String IWFClass = "F_Class";
    protected static final String IWFComment = "F_Comment";
    protected static final String IWFDeadline = "F_Deadline";
    protected static final String IWFWFDeadline = "F_WFDeadline";
    protected static final String IWFEnqueueTime = "F_EnqueueTime";
    protected static final String IWFInstrSheetName = "F_InstrSheetName";
    protected static final String IWFLastErrorNumber = "F_LastErrorNumber";
    protected static final String IWFLastErrorText = "F_LastErrorText";
    protected static final String IWFMaxMilestone = "F_MaxMilestone";
    protected static final String IWFMinMilestone = "F_MinMilestone";
    protected static final String IWFOperation = "F_Operation";
    protected static final String IWFOriginator = "F_Originator";
    protected static final String IWFOverdue = "F_Overdue";
    protected static final String IWFResponse = "F_Response";
    protected static final String IWFResponseCount = "F_ResponseCount";
    protected static final String IWFSourceDoc = "F_SourceDoc";
    protected static final String IWFStepDescription = "F_StepDescription";
    protected static final String IWFStepProcId = "F_StepProcId";
    protected static final String IWFStartTime = "F_StartTime";
    protected static final String IWFStepName = "F_StepName";
    protected static final String IWFStepStatus = "F_StepStatus";
    protected static final String IWFSubject = "F_Subject";
    protected static final String IWFTimeOut = "F_TimeOut";
    protected static final String IWFTrackerStatus = "F_TrackerStatus";
    protected static final String IWFUniqueId = "F_UniqueId";
    protected static final String IWFWorkFlowNum = "F_WorkFlowNumber";
    protected static final String WOFOccurrence = "F_Occurrence";
    protected static final String WOFReminder = "F_Reminder";
    protected static final String WOFResponses = "F_Responses";
    protected static final String WOFSplitLeg = "F_SplitLeg";
    protected static final String WOFTrackers = "F_Trackers";
    protected static final String WOFTransferUser = "F_TransferUser";
    protected static final String WOFWFDeadline = "F_WFDeadline";
    protected static final String WOFWFReminder = "F_WFReminder";
    protected static final String WOFWorkClassRevision = "F_WorkClassRevision";
    protected static final String WOFWorkFlowNumber = "F_WorkFlowNumber";
    protected static final String WOFWsCorrelation = "F_WsCorrelation";
    protected static final String WOFWsOperation = "F_WsOperation";
    protected static final String WOFWsPortType = "F_WsPortType";
    static final String[] MANDATORY_QUEUE_FIELDS = new String[]{"F_WobNum", "F_WorkSpaceId", "F_Locked", "F_LockMachine", "F_LockUser", "F_LockTime", "F_BindPending", "F_BoundUser", "F_BoundMachine", "F_Tag", "F_OperationId", "F_WorkClassId", "F_QueueWPClassId", "F_EnqueueTime", "F_CreateTime", "F_InstrSheetId", "F_WorkOrderId", "F_SortOrder"};
    static final String[] MANDATORY_ROSTER_FIELDS = new String[]{"F_WobNum", "F_WorkClassId", "F_ServerId", "F_Tag"};
    static final String[] MANDATORY_LOG_FIELDS = new String[]{"F_WobNum", "F_WorkSpaceId", "F_OperationId", "F_InstrSheetId", "F_WorkOrderId", "F_Tag", "F_ParentWobNum", "F_WorkClassId", "F_WPClassId", "F_TimeStamp", "F_SeqNumber", "F_UserId", "F_BoundUserId", "F_MachineId", "F_EventType", "F_Duration", "F_OccurrenceId", "F_Text", "F_WCRevision", "F_ServerSeqNum"};
    static final String[] OPTIONAL_QUEUE_FIELDS = new String[]{"F_Class", "F_Operation", "F_Originator", "F_WorkFlowNumber", "F_TimeOut", "F_StartTime", "F_Subject", "F_Comment", "F_Response", "F_TrackerStatus", "F_Overdue", "F_ResponseCount", "F_StepName", "F_SourceDoc", "F_StepDescription", "F_InstrSheetName", "F_LastErrorNumber", "F_LastErrorText", "F_CaseFolder", "F_CaseTask", "F_Deadline"};
    static final String[] OPTIONAL_ROSTER_FIELDS = new String[]{"F_Class", "F_Originator", "F_WorkFlowNumber", "F_StartTime", "F_Subject", "F_TrackerStatus", "F_Overdue", "F_StepName", "F_SourceDoc", "F_MinMilestone", "F_CaseFolder", "F_CaseTask"};
    static final String[] OPTIONAL_LOG_FIELDS = new String[]{"F_Class", "F_Operation", "F_Originator", "F_WorkFlowNumber", "F_TimeOut", "F_StartTime", "F_Subject", "F_Comment", "F_Response", "F_TrackerStatus", "F_Overdue", "F_ResponseCount", "F_WFDeadline", "F_EnqueueTime", "F_UniqueId", "F_StepStatus", "F_StepName", "F_StepProcId", "F_SourceDoc", "F_StepDescription", "F_InstrSheetName", "F_LastErrorNumber", "F_LastErrorText", "F_CaseFolder", "F_CaseTask"};
    private static final int MIN_CONFIG_TYPE = 1;
    public static final int CONFIG_TYPE_ROSTER = 1;
    public static final int CONFIG_TYPE_QUEUE = 2;
    public static final int CONFIG_TYPE_LOG = 3;
    private static final int MAX_CONFIG_TYPE = 3;
    private static String[] LocalizedStrings = new String[]{new VWString("VW.api.VWConfigTypeRoster", "Roster").toString(), new VWString("VW.api.VWConfigTypeQueue", "Queue").toString(), new VWString("VW.api.VWConfigTypeLog", "Log").toString()};
    private int ALLOW_ORB_TO_SET_SERVERID_TO_ALL_SERVERS = -99;
    protected boolean isSelectedForExport = true;

    public static String _get_FILE_DATE() {
        return "$Date: 2011-01-19 23:56:31 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Darik Siegfried;5D6048897;dsiegfried@us.ibm.com (dsiegfried) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_452_Int/PUI_460_Int/PUI_460_FP01_Int/1 $";
    }

    protected VWTableDefinition(String theName) throws VWException {
        if (theName == null || theName.length() == 0) {
            throw new VWException("vw.api.VWTableDefBadName", "Names cannot be null or empty.");
        }
        this.name = theName;
        this.bHasChanged = true;
    }

    protected VWTableDefinition(String theName, int theConfigType) throws VWException {
        if (theName == null || theName.length() == 0) {
            throw new VWException("vw.api.VWTableDefBadName", "Names cannot be null or empty.");
        }
        if (!VWTableDefinition.isValid(theConfigType)) {
            throw new VWException("vw.api.VWTableDefBadConfigType", "Invalid config type value {0}.", String.valueOf(theConfigType));
        }
        this.name = theName;
        this.configType = theConfigType;
        this.bHasChanged = true;
    }

    public VWExposedFieldDefinition createFieldDefinition(String theName, int theType, int theLength) throws VWException {
        if (theName == null) {
            throw new VWException("vw.api.VWParameterBadName", "Parameter name cannot be null or empty");
        }
        boolean isOptionalField = VWTableDefinition.isOptionalSystemField(theName, this.configType);
        boolean isMandatoryField = VWTableDefinition.isMandatorySystemField(theName, this.configType);
        if (!VWFieldType.isValidName(theName, !isOptionalField && !isMandatoryField)) {
            throw new VWException("vw.api.VWExpFieldDefInvalidName", "Syntax error encountered for the exposed field name: {0}.  The field name must be a unique name that begins with a letter and contains letters, numbers, and underscores only. The field name cannot exceed 128 characters, cannot be a reserved word, nor begin with F_ or VWV as the first characters.", theName);
        }
        Object[] theElements = (VWExposedFieldDefinition[])this.theFieldsHandler.getElements(this.theFieldDefs);
        int theIndex = this.theFieldsHandler.getIndexFromStringFieldValue(theElements, "name", theName);
        if (theIndex != -1) {
            throw new VWException("vw.api.VWTableDefintionFieldExists", "The field name already exists.");
        }
        if (theType != 2 && theLength != 0) {
            throw new VWException("vw.api.VWTableDefinitionInvalidFieldLength", "The field length needs to be zero for field type other than string.");
        }
        VWExposedFieldDefinition theFieldDef = new VWExposedFieldDefinition(theName, theType, theLength, isOptionalField, this.name, this.configType, this.getSession());
        theFieldDef.setHasChanged(true);
        this.theFieldDefs = (VWExposedFieldDefinition[])this.theFieldsHandler.addElementToArray(this.theFieldDefs, theFieldDef);
        this.bHasChanged = true;
        return theFieldDef;
    }

    protected VWExposedFieldDefinition createFieldDefinition(String theName, int theType, int theLength, boolean isSystemField, boolean isMandatorySystemField) throws VWException {
        if (theName.length() > 128) {
            throw new VWException("vw.api.VWTableDefFieldTooLong", "Field name is too long. {0}", theName);
        }
        if (theName.startsWith("F_")) {
            isSystemField = true;
        }
        VWExposedFieldDefinition theFieldDef = new VWExposedFieldDefinition(theName, theType, theLength, isSystemField, this.name, this.configType, this.getSession());
        theFieldDef.setMandatorySystemField(isMandatorySystemField);
        this.theFieldDefs = (VWExposedFieldDefinition[])this.theFieldsHandler.addElementToArray(this.theFieldDefs, theFieldDef);
        this.bHasChanged = true;
        return theFieldDef;
    }

    public void deleteFieldDefinition(String theName) throws VWException {
        if (theName == null) {
            throw new VWException("vw.api.VWTableDefFieldNameBad", "Field name parameter is null.");
        }
        int theIndex = this.theFieldsHandler.getIndexFromStringFieldValue(this.theFieldDefs, "name", theName);
        if (theIndex == -1) {
            throw new VWException("vw.api.VWTableDefFieldNameNotFound", "Field name not found. Field names are case sensitive. Check spelling and case.{0}", theName);
        }
        if (this.theFieldDefs[theIndex].isMandatorySystemField()) {
            throw new VWException("vw.api.VWTableDefMandatoryField", "{0} is a mandatory system field.  It cannot be deleted.", theName);
        }
        VWIndexDefinition[] theIndexDefs = this.getIndexes();
        int count = 0;
        if (theIndexDefs != null) {
            count = theIndexDefs.length;
        }
        for (int loop = 0; loop < count; ++loop) {
            if (!theIndexDefs[loop].isIn(theName)) continue;
            throw new VWException("vw.api.VWTableDefFieldInUse", "The field {0} is in use by the index {1} and may not be deleted.  Remove the field from the index and try deleting again.", theName, theIndexDefs[loop].getName());
        }
        this.theFieldsHandler.deleteElementFromArray(this.theFieldDefs, theIndex);
        this.bHasChanged = true;
    }

    protected void createFieldDefinitions(VWExposedFieldDefinition[] theDefs) throws VWException {
        if (theDefs == null) {
            return;
        }
        int length = theDefs.length;
        for (int i = 0; i < length; ++i) {
            try {
                this.createFieldDefinition(theDefs[i].getName(), theDefs[i].getFieldType(), theDefs[i].getRealLength(), theDefs[i].isSystemField(), theDefs[i].isMandatorySystemField());
                this.bHasChanged = false;
                continue;
            }
            catch (VWException e) {
                // empty catch block
            }
        }
    }

    protected VWIndexDefinition createIndexDefinition(String theName, String[] theFieldNames, VWTableDefinition theTableDefinition) throws VWException {
        Object[] theElements = (VWIndexDefinition[])this.theIndexHandler.getElements(this.theIndexDefs);
        int theIndex = this.theIndexHandler.getIndexFromStringFieldValue(theElements, "name", theName);
        if (theIndex != -1) {
            throw new VWException("vw.api.VWTableDefintionIndexExists", "The index name already exists.");
        }
        VWIndexDefinition theIndexDef = new VWIndexDefinition(theName, theFieldNames, false, theTableDefinition, this.getSession());
        theIndexDef.setHasChanged(true);
        this.theIndexDefs = (VWIndexDefinition[])this.theIndexHandler.addElementToArray(this.theIndexDefs, theIndexDef);
        this.bHasChanged = true;
        return theIndexDef;
    }

    public VWIndexDefinition createIndexDefinition(String theName, String[] theFieldNames) throws VWException {
        return null;
    }

    protected VWIndexDefinition createIndexDefinition(String theName, String[] theFieldNames, boolean systemIndex, VWTableDefinition theTableDef) throws VWException {
        this.theIndexHandler.getElements(this.theIndexDefs);
        int theIndex = this.theIndexHandler.getIndexFromStringFieldValue(this.theIndexDefs, "name", theName);
        if (theIndex != -1) {
            throw new VWException("vw.api.VWTableDefintionIndexExists", "The index name already exists.");
        }
        if (theName.length() > 128) {
            throw new VWException("vw.api.VWTableDefIndexTooLong", "Index name is too long. {0}", theName);
        }
        VWIndexDefinition theIndexDef = new VWIndexDefinition(theName, theFieldNames, systemIndex, theTableDef, this.getSession());
        theIndexDef.setHasChanged(true);
        this.theIndexDefs = (VWIndexDefinition[])this.theIndexHandler.addElementToArray(this.theIndexDefs, theIndexDef);
        this.bHasChanged = true;
        return theIndexDef;
    }

    protected void createIndexDefinitions(VWIndexDefinition[] theDefs) throws VWException {
        if (theDefs == null) {
            return;
        }
        int length = theDefs.length;
        for (int i = 0; i < length; ++i) {
            try {
                VWIndexDefinition theIndexDef = new VWIndexDefinition(theDefs[i].getName(), theDefs[i].getAuthoredFieldNames(true), theDefs[i].isSystemIndex(), theDefs[i].tableDefinition, true, this.getSession());
                theIndexDef.setMandatorySystemIndex(theDefs[i].isMandatorySystemIndex());
                this.theIndexDefs = (VWIndexDefinition[])this.theIndexHandler.addElementToArray(this.theIndexDefs, theIndexDef);
                this.bHasChanged = false;
                continue;
            }
            catch (VWException e) {
                // empty catch block
            }
        }
    }

    public void deleteIndexDefinition(String theName) throws VWException {
        if (theName == null) {
            throw new VWException("vw.api.VWTableDefIndexNameBad", "Index field name parameter is null.");
        }
        int theIndex = this.theIndexHandler.getIndexFromStringFieldValue(this.theIndexDefs, "name", theName);
        if (theIndex == -1) {
            throw new VWException("vw.api.VWTableDefIndexNameNotFound", "Index name not found. Index names are case sensitive. Check spelling and case.{0}", theName);
        }
        if (this.theIndexDefs[theIndex].isMandatorySystemIndex()) {
            throw new VWException("vw.api.VWTableDefMandatoryIndex", "{0} is a mandatory system index.  It cannot be deleted.", theName);
        }
        this.theIndexHandler.deleteElementFromArray(this.theIndexDefs, theIndex);
        this.bHasChanged = true;
    }

    public VWExposedFieldDefinition[] getFields() throws VWException {
        int index;
        VWArrayHandler fieldsHandler = (VWArrayHandler)this.theFieldsHandler.clone();
        Object[] fields = (VWExposedFieldDefinition[])this.theFieldsHandler.getElements(this.theFieldDefs);
        if (this.configType == 2 && (index = fieldsHandler.getIndexFromStringFieldValue(fields, "name", IWFUniqueId)) != -1) {
            fieldsHandler.deleteElementFromArray(fields, index);
        }
        if (fields != null) {
            for (int i = 0; i < fieldsHandler.getElementCount(); ++i) {
                if (fields[i] == null) continue;
                ((VWMLABase)fields[i]).setSession(this.getSession());
            }
        }
        return (VWExposedFieldDefinition[])fieldsHandler.getElements(fields);
    }

    public VWIndexDefinition[] getIndexes() throws VWException {
        if (this.theIndexDefs != null) {
            for (int i = 0; i < this.theIndexHandler.getElementCount(); ++i) {
                if (this.theIndexDefs[i] == null) continue;
                this.theIndexDefs[i].setSession(this.getSession());
            }
        }
        return (VWIndexDefinition[])this.theIndexHandler.getElements(this.theIndexDefs);
    }

    public String getName() {
        return this.translateStr(this.name);
    }

    public String[] getReadSecurity() {
        if (this.readSecurity != null) {
            return this.readSecurity;
        }
        this.readSecurity = this.convertSecurityPxtoSecurity(this.readSecurityPx);
        return this.readSecurity;
    }

    public VWParticipant[] getReadSecurityPx() throws VWException {
        if (this.readSecurityPx == null) {
            if (this.readSecurity == null) {
                return null;
            }
            ArrayList<VWParticipant> tmpList = new ArrayList<VWParticipant>();
            for (int i = 0; i < this.readSecurity.length; ++i) {
                if (this.readSecurity[i] == null) continue;
                tmpList.add(new VWParticipant(this.readSecurity[i]));
            }
            if (tmpList.size() > 0) {
                this.readSecurityPx = tmpList.toArray(new VWParticipant[0]);
            }
        } else {
            this.checkSecurityCommandSession(this.readSecurityPx);
        }
        return this.readSecurityPx;
    }

    protected String[] getReadSecurityList() {
        String[] securityList = null;
        if (this.readSecurityPx != null) {
            securityList = this.convertSecurityPxtoSecurity(this.readSecurityPx);
        } else if (this.readSecurity != null) {
            securityList = this.readSecurity;
        }
        return securityList;
    }

    protected void setReadSecurity(String[] theNames) throws VWException {
        this.readSecurity = theNames;
        this.readSecurityPx = null;
        this.bHasChanged = true;
    }

    protected void setReadSecurityPx(VWParticipant[] thePxList) throws VWException {
        this.readSecurityPx = thePxList;
        this.readSecurity = null;
        this.bHasChanged = true;
    }

    public int getServerId() {
        return this.serverId;
    }

    public void setServerId(int theNewServerId) throws VWException {
        if (theNewServerId == this.ALLOW_ORB_TO_SET_SERVERID_TO_ALL_SERVERS) {
            theNewServerId = -1;
        } else if (theNewServerId < 0) {
            throw new VWException("vw.api.VWTableDefServerIdErr", "The server id can not be a negative value.");
        }
        this.serverId = theNewServerId;
        this.bHasChanged = true;
    }

    public String[] getWriteSecurity() {
        if (this.writeSecurity != null) {
            return this.writeSecurity;
        }
        this.writeSecurity = this.convertSecurityPxtoSecurity(this.writeSecurityPx);
        return this.writeSecurity;
    }

    public VWParticipant[] getWriteSecurityPx() throws VWException {
        if (this.writeSecurityPx == null) {
            if (this.writeSecurity == null) {
                return null;
            }
            ArrayList<VWParticipant> tmpList = new ArrayList<VWParticipant>();
            for (int i = 0; i < this.writeSecurity.length; ++i) {
                if (this.writeSecurity[i] == null) continue;
                tmpList.add(new VWParticipant(this.writeSecurity[i]));
            }
            if (tmpList.size() > 0) {
                this.writeSecurityPx = tmpList.toArray(new VWParticipant[0]);
            }
        } else {
            this.checkSecurityCommandSession(this.writeSecurityPx);
        }
        return this.writeSecurityPx;
    }

    protected String[] getWriteSecurityList() {
        String[] securityList = null;
        if (this.writeSecurityPx != null) {
            securityList = this.convertSecurityPxtoSecurity(this.writeSecurityPx);
        } else if (this.writeSecurity != null) {
            securityList = this.writeSecurity;
        }
        return securityList;
    }

    protected void setWriteSecurity(String[] theNames) throws VWException {
        this.writeSecurity = theNames;
        this.writeSecurityPx = null;
        this.bHasChanged = true;
    }

    protected void setWriteSecurityPx(VWParticipant[] thePxList) throws VWException {
        this.writeSecurity = null;
        this.writeSecurityPx = thePxList;
        this.bHasChanged = true;
    }

    public String getDescription() {
        return this.translateStr(this.description);
    }

    public void setDescription(String theDescription) {
        this.description = theDescription;
        this.bHasChanged = true;
    }

    public String toString() {
        return this.name;
    }

    protected boolean hasChanged() throws VWException {
        VWIndexDefinition[] theIndexes;
        int i;
        VWExposedFieldDefinition[] theFields;
        if (!this.bHasChanged && (theFields = this.getFields()) != null) {
            for (i = 0; i < theFields.length && !this.bHasChanged; ++i) {
                if (!theFields[i].hasChanged()) continue;
                this.bHasChanged = true;
                return true;
            }
        }
        if (!this.bHasChanged && (theIndexes = this.getIndexes()) != null) {
            for (i = 0; i < theIndexes.length; ++i) {
                if (!theIndexes[i].hasChanged()) continue;
                this.bHasChanged = true;
                return true;
            }
        }
        return this.bHasChanged;
    }

    protected void setHasChanged(boolean theNewValue) throws VWException {
        VWIndexDefinition[] theIndexes;
        this.bHasChanged = theNewValue;
        VWExposedFieldDefinition[] theFields = this.getFields();
        if (theFields != null) {
            for (int i = 0; i < theFields.length; ++i) {
                theFields[i].setHasChanged(theNewValue);
            }
        }
        if ((theIndexes = this.getIndexes()) != null) {
            for (int i = 0; i < theIndexes.length; ++i) {
                theIndexes[i].setHasChanged(theNewValue);
            }
        }
    }

    protected static boolean isMandatorySystemField(String theFieldName, int theType) {
        switch (theType) {
            case 2: {
                for (int i = 0; i < MANDATORY_QUEUE_FIELDS.length; ++i) {
                    if (theFieldName.compareTo(MANDATORY_QUEUE_FIELDS[i]) != 0) continue;
                    return true;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < MANDATORY_ROSTER_FIELDS.length; ++i) {
                    if (theFieldName.compareTo(MANDATORY_ROSTER_FIELDS[i]) != 0) continue;
                    return true;
                }
                break;
            }
            case 3: {
                for (int i = 0; i < MANDATORY_LOG_FIELDS.length; ++i) {
                    if (theFieldName.compareTo(MANDATORY_LOG_FIELDS[i]) != 0) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    protected static boolean isOptionalSystemField(String theFieldName, int theType) {
        switch (theType) {
            case 2: {
                for (int i = 0; i < OPTIONAL_QUEUE_FIELDS.length; ++i) {
                    if (theFieldName.compareTo(OPTIONAL_QUEUE_FIELDS[i]) != 0) continue;
                    return true;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < OPTIONAL_ROSTER_FIELDS.length; ++i) {
                    if (theFieldName.compareTo(OPTIONAL_ROSTER_FIELDS[i]) != 0) continue;
                    return true;
                }
                break;
            }
            case 3: {
                for (int i = 0; i < OPTIONAL_LOG_FIELDS.length; ++i) {
                    if (theFieldName.compareTo(OPTIONAL_LOG_FIELDS[i]) != 0) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public static VWExposedFieldDefinition[] optionalSystemFields(int theType) throws VWException {
        if (theType != 3 && theType != 2 && theType != 1) {
            throw new VWException("vw.api.VWTableDefInvalidType", "Type must specify Queue, Log or Roster.");
        }
        VWExposedFieldDefinition EFClass = new VWExposedFieldDefinition(IWFClass, 2, 80, true, "ALL", theType);
        VWExposedFieldDefinition EFOperation = new VWExposedFieldDefinition(IWFOperation, 2, 80, true, "ALL", theType);
        VWExposedFieldDefinition EFOriginator = new VWExposedFieldDefinition(IWFOriginator, 1, 0, true, "ALL", theType);
        VWExposedFieldDefinition EFWorkFlowNum = new VWExposedFieldDefinition("F_WorkFlowNumber", 2, 16, true, "ALL", theType);
        VWExposedFieldDefinition EFTimeout = new VWExposedFieldDefinition(IWFTimeOut, 16, 0, true, "ALL", theType);
        VWExposedFieldDefinition EFStartTime = new VWExposedFieldDefinition(IWFStartTime, 16, 0, true, "ALL", theType);
        VWExposedFieldDefinition EFSubject = new VWExposedFieldDefinition(IWFSubject, 2, 255, true, "ALL", theType);
        VWExposedFieldDefinition EFComment = new VWExposedFieldDefinition(IWFComment, 2, 80, true, "ALL", theType);
        VWExposedFieldDefinition EFResponse = new VWExposedFieldDefinition(IWFResponse, 2, 80, true, "ALL", theType);
        VWExposedFieldDefinition EFTrackerStatus = new VWExposedFieldDefinition(IWFTrackerStatus, 1, 0, true, "ALL", theType);
        VWExposedFieldDefinition EFOverdue = new VWExposedFieldDefinition(IWFOverdue, 1, 0, true, "ALL", theType);
        VWExposedFieldDefinition EFResponseCount = new VWExposedFieldDefinition(IWFResponseCount, 1, 0, true, "ALL", theType);
        VWExposedFieldDefinition EFMinMilestone = new VWExposedFieldDefinition(IWFMinMilestone, 1, 0, true, "ALL", theType);
        VWExposedFieldDefinition EFWFDeadline = new VWExposedFieldDefinition("F_WFDeadline", 1, 0, true, "ALL", theType);
        VWExposedFieldDefinition EFEnqueueTime = new VWExposedFieldDefinition("F_EnqueueTime", 16, 0, true, "ALL", theType);
        VWExposedFieldDefinition EFUniqueueId = new VWExposedFieldDefinition(IWFUniqueId, 8, 0, true, "ALL", theType);
        VWExposedFieldDefinition EFStepName = new VWExposedFieldDefinition(IWFStepName, 2, 64, true, "ALL", theType);
        VWExposedFieldDefinition EFStepStatus = new VWExposedFieldDefinition(IWFStepStatus, 1, 0, true, "ALL", theType);
        VWExposedFieldDefinition EFStepDescription = new VWExposedFieldDefinition(IWFStepDescription, 2, 128, true, "ALL", theType);
        VWExposedFieldDefinition EFInstructionSheetName = new VWExposedFieldDefinition(IWFInstrSheetName, 2, 32, true, "ALL", theType);
        VWExposedFieldDefinition EFLastErrorNumber = new VWExposedFieldDefinition(IWFLastErrorNumber, 1, 0, true, "ALL", theType);
        VWExposedFieldDefinition EFLastErrorText = new VWExposedFieldDefinition(IWFLastErrorText, 2, 128, true, "ALL", theType);
        VWExposedFieldDefinition EFStepProcId = new VWExposedFieldDefinition(IWFStepProcId, 1, 0, true, "ALL", theType);
        VWExposedFieldDefinition EFSourceDoc = new VWExposedFieldDefinition(IWFSourceDoc, 2, 128, true, "ALL", theType);
        VWExposedFieldDefinition EFCaseFolder = new VWExposedFieldDefinition(IWFCaseFolder, 512, 40, true, "ALL", theType);
        VWExposedFieldDefinition EFCaseTask = new VWExposedFieldDefinition(IWFCaseTask, 512, 40, true, "ALL", theType);
        VWExposedFieldDefinition EFDeadline = new VWExposedFieldDefinition(IWFDeadline, 16, 0, true, "ALL", theType);
        if (theType == 1) {
            VWExposedFieldDefinition[] optionalFields = new VWExposedFieldDefinition[]{EFClass, EFOriginator, EFWorkFlowNum, EFStartTime, EFSubject, EFTrackerStatus, EFOverdue, EFStepName, EFSourceDoc, EFMinMilestone, EFCaseFolder, EFCaseTask};
            return optionalFields;
        }
        if (theType == 2) {
            VWExposedFieldDefinition[] optionalFields = new VWExposedFieldDefinition[]{EFClass, EFOperation, EFOriginator, EFWorkFlowNum, EFTimeout, EFStartTime, EFSubject, EFComment, EFResponse, EFTrackerStatus, EFOverdue, EFResponseCount, EFStepName, EFSourceDoc, EFStepDescription, EFInstructionSheetName, EFLastErrorNumber, EFLastErrorText, EFCaseFolder, EFCaseTask, EFDeadline};
            return optionalFields;
        }
        VWExposedFieldDefinition[] optionalFields = new VWExposedFieldDefinition[]{EFClass, EFOperation, EFOriginator, EFWorkFlowNum, EFTimeout, EFStartTime, EFSubject, EFComment, EFResponse, EFTrackerStatus, EFOverdue, EFResponseCount, EFWFDeadline, EFEnqueueTime, EFUniqueueId, EFStepStatus, EFStepName, EFStepProcId, EFSourceDoc, EFStepDescription, EFInstructionSheetName, EFLastErrorNumber, EFLastErrorText, EFCaseFolder, EFCaseTask};
        return optionalFields;
    }

    public boolean hasFieldName(String fieldName) throws VWException {
        if (this.theFieldDefs != null) {
            for (int i = 0; i < this.theFieldDefs.length; ++i) {
                if (this.theFieldDefs[i] == null || !this.theFieldDefs[i].getName().equals(fieldName)) continue;
                return true;
            }
        }
        return false;
    }

    protected String[] stripDomain(String[] names) throws VWException {
        String DELIM = String.valueOf(":");
        StringTokenizer stmp = null;
        String[] result = null;
        if (names != null) {
            result = new String[names.length];
            for (int i = 0; i < names.length; ++i) {
                result[i] = names[i] == null || names[i].length() == 0 ? names[i] : ((stmp = new StringTokenizer(names[i], DELIM, false)).hasMoreTokens() ? stmp.nextToken() : names[i]);
            }
        }
        return result;
    }

    protected VWIndexDefinition getIndex(String name) throws VWException {
        VWIndexDefinition result = null;
        String tmpdefName = null;
        String tmpdefAuthoredName = null;
        if (this.theIndexDefs == null || name == null) {
            return result;
        }
        for (int i = 0; i < this.theIndexDefs.length; ++i) {
            if (this.theIndexDefs[i] == null) continue;
            tmpdefName = this.theIndexDefs[i].getName();
            tmpdefAuthoredName = this.theIndexDefs[i].getAuthoredName();
            if ((tmpdefName == null || !name.equals(tmpdefName)) && (tmpdefAuthoredName == null || !name.equals(tmpdefAuthoredName))) continue;
            result = this.theIndexDefs[i];
            break;
        }
        return result;
    }

    protected VWExposedFieldDefinition getExposedField(String name) throws VWException {
        VWExposedFieldDefinition result = null;
        String tmpdefName = null;
        String tmpdefAuthoredName = null;
        if (this.theFieldDefs == null || name == null) {
            return result;
        }
        for (int i = 0; i < this.theFieldDefs.length; ++i) {
            if (this.theFieldDefs[i] == null) continue;
            tmpdefName = this.theFieldDefs[i].getName();
            tmpdefAuthoredName = this.theFieldDefs[i].getAuthoredName();
            if ((tmpdefName == null || !name.equals(tmpdefName)) && (tmpdefAuthoredName == null || !name.equals(tmpdefAuthoredName))) continue;
            result = this.theFieldDefs[i];
            break;
        }
        return result;
    }

    public Object clone() {
        try {
            int i;
            VWTableDefinition tableDef = (VWTableDefinition)super.clone();
            if (this.theFieldDefs != null) {
                tableDef.theFieldDefs = new VWExposedFieldDefinition[this.theFieldDefs.length];
                for (i = 0; i < this.theFieldDefs.length; ++i) {
                    if (this.theFieldDefs[i] == null) continue;
                    tableDef.theFieldDefs[i] = (VWExposedFieldDefinition)this.theFieldDefs[i].clone();
                }
            }
            tableDef.theFieldsHandler = (VWArrayHandler)this.theFieldsHandler.clone();
            if (this.theIndexDefs != null) {
                tableDef.theIndexDefs = new VWIndexDefinition[this.theIndexDefs.length];
                for (i = 0; i < this.theIndexDefs.length; ++i) {
                    if (this.theIndexDefs[i] == null) continue;
                    tableDef.theIndexDefs[i] = (VWIndexDefinition)this.theIndexDefs[i].clone();
                    tableDef.theIndexDefs[i].tableDefinition = tableDef;
                }
            }
            tableDef.theIndexHandler = (VWArrayHandler)this.theIndexHandler.clone();
            return tableDef;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public static String getLocalizedString(int theConfigType) throws VWException {
        if (!VWTableDefinition.isValid(theConfigType)) {
            throw new VWException("vw.api.VWTableDefTypeBadInteger", "Integer form of the config type is invalid: {0}", String.valueOf(theConfigType));
        }
        return LocalizedStrings[theConfigType - 1];
    }

    public static boolean isValid(int theConfigType) {
        return theConfigType >= 1 && theConfigType <= 3;
    }

    protected static String getTableName(VWTableDefinition tableDef) {
        return tableDef.getName();
    }

    protected void setAttributeInfo(VWAttributeInfo theAttributeInfo) throws VWException {
        Hashtable theAttributes;
        this.attributes = theAttributeInfo != null ? (theAttributes = theAttributeInfo.attributes) : null;
        this.bHasChanged = true;
    }

    protected VWAttributeInfo getAttributeInfo() throws VWException {
        return new VWAttributeInfo(this.attributes);
    }

    protected Hashtable getAttributes() throws VWException {
        return this.attributes;
    }

    protected void setAttributes(Hashtable theAttributes) throws VWException {
        this.attributes = theAttributes;
    }

    protected String[] getAttributeNames() throws VWException {
        return VWAttributeInfo.getAttributeNames(this.attributes);
    }

    protected String[] convertSecurityPxtoSecurity(VWParticipant[] securityPx) {
        int sz;
        Object[] security = null;
        if (securityPx != null && (sz = securityPx.length) > 0) {
            Vector<String> securityCol = new Vector<String>();
            for (int i = 0; i < sz; ++i) {
                if (securityPx[i] == null) continue;
                securityCol.add(securityPx[i].getParticipantName());
            }
            if (securityCol.size() > 0) {
                security = new String[securityCol.size()];
                securityCol.copyInto(security);
            }
        }
        return security;
    }

    protected void checkSecurityCommandSession(VWParticipant[] securityPx) throws VWException {
        if (securityPx != null) {
            int sz = securityPx.length;
            if (sz > 0 && securityPx[0].getCommandSession() != null) {
                return;
            }
            Object cmdSession = this.getSession();
            if (cmdSession != null) {
                cmdSession = this.getSession().cmdSession;
            } else if (cmdSession == null) {
                return;
            }
            for (int i = 0; i < sz; ++i) {
                securityPx[i].setCommandSession((IPECommands)cmdSession);
            }
        }
    }

    protected void setIsSelectedForExport(boolean selectIt) {
        this.isSelectedForExport = selectIt;
    }

    protected boolean getIsSelectedForExport() {
        return this.isSelectedForExport;
    }
}

